/* -*-c++-*- Copyright (C) 2018 Advanced Driver Information Technology.
 *
 * This library is open source and may be redistributed and/or modified under
 * the terms of the OpenSceneGraph Public License (OSGPL) version 0.0 or
 * (at your option) any later version.  The full license is in LICENSE file
 * included with this distribution, and on the openscenegraph.org website.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * OpenSceneGraph Public License for more details.
*/

#include "WLRegistry.hpp"

using namespace WaylandBackend;

const struct wl_registry_listener WLRegistry::_registryListener = {
        WLRegistry::registryHandleGlobal,
        WLRegistry::registryHandleGlobalRemove
};

WLRegistry::WLRegistry(struct wl_display *wlDisplay,
                       struct wl_event_queue *eventQ)
{
    if (NULL != eventQ)
    {
        struct wl_display* wrappedDisplay = (struct wl_display*)
                                wl_proxy_create_wrapper((void *)wlDisplay);
        if (NULL != wrappedDisplay)
        {
            wl_proxy_set_queue((struct wl_proxy*)wrappedDisplay, eventQ);
            _wlRegistry = (struct wl_registry*)
                          wl_display_get_registry(wrappedDisplay);
            wl_proxy_wrapper_destroy(wrappedDisplay);
        }
    }
    else
    {
        /*
         * It is not good idea to use default queue. default queue can be
         * dispatched by multiple threads
         */
        _wlRegistry = (struct wl_registry*)
                       wl_display_get_registry(wlDisplay);
    }
    if (NULL != _wlRegistry)
        wl_registry_add_listener(_wlRegistry, &_registryListener, (void*)this);
}

WLRegistry::~WLRegistry()
{
    if (NULL != _wlRegistry)
    {
        wl_registry_destroy(_wlRegistry);
    }
}


void
WLRegistry::registryHandleGlobal(void* data, struct wl_registry* registry,
                                 uint32_t name, const char* interface,
                                 uint32_t version)
{
    WLRegistry *pRegistry = static_cast<WLRegistry*> (data);
    if (NULL != pRegistry)
    {
        pRegistry->registryGlobal(registry, name, interface, version);
    }
}

void
WLRegistry::registryHandleGlobalRemove(void* data,
                                       struct wl_registry* registry,
                                       uint32_t name)
{
    WLRegistry *pRegistry = static_cast<WLRegistry*> (data);
    if (NULL != pRegistry)
    {
        pRegistry->registryGlobalRemove(registry, name);
    }
}
